// 8EchoServer.cpp: implementation of the C8EchoServer class.
//
//////////////////////////////////////////////////////////////////////

#include	"stdafx.h"

#include	"8EchoServer.h"
#include	"8Callback.h"
#include	"8Connection.h"
#include	"8PKPool.h"

#include	"misc.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

C8EchoServer::C8EchoServer()
{
	m_hStopEvent = NULL;
}

C8EchoServer::~C8EchoServer()
{
	if( m_hStopEvent)
		CloseHandle( m_hStopEvent );
}

//////////////////////////////////////////////////////////////////////
BOOL C8EchoServer::Start()
{
	SOCKET			listener;
	WSADATA			wsaData;

	SOCKADDR_IN		addr;
					addr.sin_family			= AF_INET;
					addr.sin_addr.s_addr	= INADDR_ANY;
					addr.sin_port			= htons( (short)SERVER_PORT );

	HANDLE			hTimerQTimer = NULL;
	int				idx = 0;

	C8Connection*	pConnection = NULL;
	C8PKPool*		pPKPool = NULL;


	// initialize socket library
	if( SOCKET_ERROR == WSAStartup(0x202,&wsaData) )
		goto errors;

	// create listen socket
	if( INVALID_SOCKET == (listener=socket(AF_INET,SOCK_STREAM,0)) )
		goto errors;

	// bind listen socket
	if( 0 != bind(listener,(SOCKADDR *)&addr,sizeof(addr)) )
		goto errors;

	// listening for an incoming connection
	if( 0 != listen(listener,5) )
		goto errors;

	// create memory pool for ovl structure and packet buffer
	if( 0 == (pPKPool = new C8PKPool) )
		goto errors;
	//
//	if( 0 == pPKPool->Create("c:\\echopacket.log") )
	if( 0 == pPKPool->Create() )
		goto errors;


	// create user
	if( 0 == (pConnection = new C8Connection[MAXUSER]) )
		goto errors;

	// initialize user
	for( idx = 0; idx < MAXUSER; idx++ )
		if( 0 == pConnection[idx].Create(idx+1,listener,pPKPool) )
			goto errors;

#if 0
	// create a multishot timer that begins firing after 15 second.
	// non-I/O component, WT_EXECUTEINIOTHREAD | WT_EXECUTELONGFUNCTION 
	if( 0 == CreateTimerQueueTimer(&hTimerQTimer,NULL,
		CheckConnectionCallback,pConnection,TIMELIMIT,TIMELIMIT,0) )
		goto errors;
#endif

	// bind listen socket to iocp thread pool
	if( 0 == BindIoCompletionCallback((HANDLE)listener,
		IoCompletionCallback,0) )
		goto errors;

	// create event for stop thread pool
	if( NULL == (m_hStopEvent=CreateEvent(0,TRUE,FALSE,0)) )
		goto errors;


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
	char	szDate[32],
			szTime[32];

	_tzset();
	_strdate( szDate );
	_strtime( szTime );

	printf( "%s %s initialized at %s, %s\n",
		SERVER_NAME, SERVER_VERSION, szDate, szTime );

	// wait for stop event signal, ־ ⼭ ·..
	WaitForSingleObject( m_hStopEvent, INFINITE );
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////


errors:
	// close stop event
	if( m_hStopEvent )
	{
		CloseHandle( m_hStopEvent );
		m_hStopEvent = NULL;
	}

#if 0
 	// cancel the timer & delete the timer queue
	if( hTimerQTimer != NULL )
		DeleteTimerQueueTimer( NULL, hTimerQTimer, NULL );
#endif

	// close all User socket
	if( pConnection )
	{
		printf( "shutdown user context..\n" );
//		for( idx = 0; idx < MAXUSER; idx++ )
//			pConnection[idx].Shutdown( NULL, TRUE );
		delete [] pConnection;
	}

	// shutdown packet pool
	if( pPKPool )
	{
		printf( "shutdown packet pool..\n" );
		delete pPKPool;
	}

	// close socket
	if( listener != INVALID_SOCKET )
	{
		struct linger li = {1, 0};	// Default: SO_DONTLINGER
		shutdown( listener, SD_BOTH );
		setsockopt( listener, SOL_SOCKET, SO_LINGER, (char *)&li, sizeof(li) );
		closesocket( listener );
		listener = INVALID_SOCKET;
	}

	//
	WSACleanup();

	printf( "shutdown sequence finished..\n\npress any key." );

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
BOOL C8EchoServer::Stop()
{
	SetEvent( m_hStopEvent );

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
BOOL C8EchoServer::Restart()
{
	return TRUE;
}
